import { BASE_URL } from "@/services/ApiEndpoints";
import axios from "axios";
const baseURL = BASE_URL;

const axiosInstance = axios.create({
  baseURL,
  headers: {
    "Content-Type": "application/json",
  },
});

async function GetRequest(endpoint, authToken = "", params = {}, headers = {}) {
  try {
    const res = await axiosInstance.get(endpoint, {
      params,
      headers: {
        ...axiosInstance.defaults.headers,
        Authorization: `Bearer ${authToken}`,
        ...headers,
      },
    });

    return res.data;
  } catch (error) {
    console.error("Error in GetRequest:", error);
    throw error;
  }
}

async function PostLoginAndSignup(endpoint, data, headers = {}) {
  try {
    const res = await axiosInstance.post(endpoint, data, {
      headers: { ...axiosInstance.defaults.headers, ...headers },
    });
    return res.data;
  } catch (error) {
    throw error;
  }
}

async function PostRequest(
  endpoint,
  data = {},
  authToken = "",
  params = {},
  headers = {}
) {
  try {
    const res = await axiosInstance.post(endpoint, data, {
      params,
      headers: {
        ...axiosInstance.defaults.headers,
        Authorization: `Bearer ${authToken}`,
        ...headers,
      },
    });
    return res.data;
  } catch (error) {
    throw error;
  }
}

async function PostForgotPass(endpoint, data, params = {}, headers = {}) {
  try {
    const res = await axiosInstance.post(endpoint, data, {
      params,
      headers: {
        ...axiosInstance.defaults.headers,
        ...headers,
      },
    });
    return res.data;
  } catch (error) {
    throw error;
  }
}

async function PostLogout(endpoint, authToken = "", params = {}, headers = {}) {
  try {
    const res = await axiosInstance.post(
      endpoint,
      {},
      {
        params,
        headers: {
          ...axiosInstance.defaults.headers,
          Authorization: `Bearer ${authToken}`,
          ...headers,
        },
      }
    );
    return res.data;
  } catch (error) {
    throw error;
  }
}

async function DeleteRequest(endpoint, authToken = "", headers = {}) {
  try {
    const res = await axiosInstance.delete(endpoint, {
      headers: {
        ...axiosInstance.defaults.headers,
        Authorization: `Bearer ${authToken}`,
        ...headers,
      },
    });
    return res.data;
  } catch (error) {
    throw error;
  }
}

async function PutRequest(
  endpoint,
  data,
  authToken = "",
  params = {},
  headers = {}
) {
  try {
    const res = await axiosInstance.put(endpoint, data, {
      params,
      headers: {
        ...axiosInstance.defaults.headers,
        Authorization: `Bearer ${authToken}`,
        ...headers,
      },
    });
    return res.data;
  } catch (error) {
    throw error;
  }
}

export {
  GetRequest,
  PostLoginAndSignup,
  PostRequest,
  PostLogout,
  DeleteRequest,
  PutRequest,
  PostForgotPass,
};